﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using MafiaFormats;

[System.Serializable]
public class RepLoader : BaseLoader
{


    [System.Serializable]
    class ObjectDefinitionFrameTypeUnk
    {
        public uint frameA, type;
        public uint[] unk; // Здесь их 6 читается
    }

    [System.Serializable]
    public class ObjectDefinitionTemplate
    {
        public uint frameA, type;
        public float x, y, z, dx, dy, dz; // XYZ is positions. dX,dY,dZ - rotations.
        public float rotateX; // One of Magicvar. Rotate char above X asxes. Maybe this is Quaternion.
    }
    [System.Serializable]
    class ObjectDefinitionFrameTypeHumA : ObjectDefinitionTemplate
    {

        public uint animationID; 

    }
    [System.Serializable] //Вздох
    class ObjectDefinitionFrameTypeHumB : ObjectDefinitionTemplate
    {
        public uint animationID; 
        public ushort animationSpeed;

    }
    [System.Serializable]
    public class ObjectDefinitionFrameTypeCar : ObjectDefinitionTemplate
    {
        public uint unk1, unk2;
    }
    [System.Serializable]
    public class ObjectDefinitionFrameTypeAct : ObjectDefinitionTemplate
    {
        public float unk1, unk2, unk3, unk4, unk5, unk6;
        public uint[] unk = new uint[8]; // их тут восемь
    }




    [System.Serializable]
    public class ObjectDefinitionBlock
    {
        public string Name; //36 чаров
        public string NameTypeFlags; // 36 чаров
        public ulong[] chkData = new ulong[2];
        public uint chkDataEmpty;
        public uint timeActivation;
        public uint definitionID;
        public uint size;
        public uint offset;

    }

    [System.Serializable]
    public class CameraChank
    {
        public uint frameA_Chank;
        public uint frameB_Chank;
        public uint unkType;
        public float x, y, z;
        public float curveX, curveY, curveZ, subCurveX, subCurveY, subCurveZ, rollView;
        public float FOV;
        public char[] unk1 = new char[8];
    };
    [System.Serializable]
    public class CameraChankFocus
    {
        public uint frameA_Focus;
        public uint frameB_Focus;
        public uint unkType;
        public float x, y, z;
        public float curveX, curveY, curveZ, subCurveX, subCurveY, subCurveZ;
        public char[] unk2 = new char[8];
    };



    [System.Serializable]
    public class AnimationBlock
    {
        public uint animationID;
        public string animationName;

    }

    [System.Serializable]
    public class AnimationBlockData
    {
        public uint countOfAnimationBlocks;
        public uint unknown;
        public AnimationBlock[] blocks;
    }

    [System.Serializable]
    public class Header
    {

        public uint magicByte;
        public uint sizeOfAnimationBlocks;
        public uint sizeOfObjectDefinitionsSection;
        public uint countOfObjectDefinitionBlocks;
        public uint fixedCCSequence;
        public uint countOfCameraChunks;
        public uint countOfCameraFocusChunks;
        public uint sizeOfScriptEventsSequence;
        public uint sizeOfDialogSection;
        public char[] padding;

    }





    Header ReaderHeader(BinaryReader reader)
    {
        Header newHeader = new Header();
        newHeader.magicByte = reader.ReadUInt32();
        newHeader.sizeOfAnimationBlocks = reader.ReadUInt32();
        newHeader.sizeOfObjectDefinitionsSection = reader.ReadUInt32();
        newHeader.countOfObjectDefinitionBlocks = reader.ReadUInt32();
        newHeader.fixedCCSequence = reader.ReadUInt32();
        newHeader.countOfCameraChunks = reader.ReadUInt32();
        newHeader.countOfCameraFocusChunks = reader.ReadUInt32();
        newHeader.sizeOfScriptEventsSequence = reader.ReadUInt32();
        newHeader.sizeOfDialogSection = reader.ReadUInt32();
        newHeader.padding = reader.ReadChars(60);
        return newHeader;
    }

        ObjectDefinitionBlock ReadObjDefBlock (BinaryReader reader)
    {
        ObjectDefinitionBlock objDef = new ObjectDefinitionBlock();

        byte[] tempchar = new byte[36];
        tempchar = reader.ReadBytes(36);
        objDef.Name = System.Text.Encoding.Default.GetString(tempchar);

        tempchar = reader.ReadBytes(36);
        objDef.NameTypeFlags = System.Text.Encoding.Default.GetString(tempchar);

        objDef.chkData[0] = reader.ReadUInt64();
        objDef.chkData[1] = reader.ReadUInt64();

        objDef.chkDataEmpty = reader.ReadUInt32();
        objDef.timeActivation = reader.ReadUInt32();

        objDef.definitionID = reader.ReadUInt32();
        objDef.size = reader.ReadUInt32();
        objDef.offset = reader.ReadUInt32();


        return objDef;

    }


    AnimationBlockData ReadAniBlock(BinaryReader reader)
    {
        AnimationBlockData blockData = new AnimationBlockData();

        blockData.countOfAnimationBlocks = reader.ReadUInt32();
        blockData.unknown = reader.ReadUInt32();

        blockData.blocks = new AnimationBlock[blockData.countOfAnimationBlocks];

        for (int i = 0; i < blockData.countOfAnimationBlocks; i++)
        {
            blockData.blocks[i] = new AnimationBlock();
            blockData.blocks[i].animationID = reader.ReadUInt32();
            byte[] tempchar = new byte[48];
            tempchar = reader.ReadBytes(48);
            blockData.blocks[i].animationName = System.Text.Encoding.Default.GetString(tempchar);

        }

        return blockData;
    }


    public Header header;
    public AnimationBlockData animBlockData;
    public ObjectDefinitionBlock[] objdefBlocks;

    public void LoadRep(BinaryReader reader)
    {

        this.header = this.ReaderHeader(reader);
        /*
            if (this.header.magicByte != 5681)
            {
                Console.WriteLine("Dude. That's not Mafia 1 Cutscene .rep file. Canceling");
                return;
            }*/

        objdefBlocks = new ObjectDefinitionBlock[this.header.countOfObjectDefinitionBlocks];

        this.animBlockData = this.ReadAniBlock(reader);



        uint pos = 96 + (108*this.header.countOfObjectDefinitionBlocks+ this.header.sizeOfObjectDefinitionsSection);

        for (int i = 0; i < this.header.countOfObjectDefinitionBlocks; i++)
        {
            objdefBlocks[i] = new ObjectDefinitionBlock();
            objdefBlocks[i] = this.ReadObjDefBlock(reader);


            UnityEngine.Debug.Log(objdefBlocks[i].NameTypeFlags); 

        }
        
    }
}


